<?PHP 
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

	$CI = get_instance();	
		
	//set forward/reply specific values blank if needed
	if(!isset($quote_body)) $quote_body = ''; 
	if(!isset($flag_value)) $flag_value = ''; 
	if(!isset($parent_message_id)) $parent_message_id = '';	
	
	if(!isset($attachments)) $attachments = array();
	$priorities = array("high" => "High Importance", "normal" => "Normal Importance", "low" => "Low Importance");

	$this->load->view('header/header');
	echo $this->load->view('message_modal', compact('feedback_message', 'feedback_class'), TRUE);
	echo $this->load->view('disabled_service_notification', array(), TRUE);	
?>
<?PHP
	if($this->session->flashdata('authorize_url')) {
		$authorize_url = $this->session->flashdata('authorize_url');
?>
		<a id="authorize_url" href="<?PHP echo $authorize_url; ?>" style="display: none;"></a>
		<script type="text/javascript">
			$().ready(function() {
				$('#authorize_url').fancybox({'type':'iframe'});
				$('#authorize_url').click();
			});
		</script>
<?PHP
	}
?>
		<a class="hidden_context hidden_link" name="menuContent" id="menuContent">Menu</a>
		<a class="hidden_context hidden_link" name="menuContent" id="skipMenu" href="#mailboxListContent">Skip Menu</a>
		<div id="menu">	
			<div id="menuwrap">
				<div id="buttons">
					<button class="minimal minimal-short" onclick="loadingScreen();" type="submit" id="send_btn" name="send">Send</button>
					<button class="minimal minimal-short" onclick="loadingScreen();" type="submit" id="save_btn" name="save">Save</button>
					<a href="/inbox">Cancel</a>
				</div>
				<div id="action_buttons">
					<button class="minimal address-book" title="Global Address Book" type="button"><img src="/images/globaladdressbook.png" title="Global Address Book" alt="Global Address Book Icon" /><div class="hidden_context">Global Address Book</div></button>
					<button class="minimal contact-list" title="Personal Contact List" type="button"><img src="/images/contactlist.png" title="Personal Contacts List" alt="Personal Contacts List Icon" /><div class="hidden_context">Personal Contacts List</div></button>
				</div>
			</div>
		</div>
	</div>
	<div id="header_padding"></div>
	<div id="mailbox_wrapper">
		<a name="mailboxListContent" id="mailboxListContent" class="hidden_context hidden_link">Mailbox List</a>
		<a class="hidden_context hidden_link" href="#mainContent" id="skipMailboxList">Skip Mailbox List</a>
		<div id="mailboxes">
			<button class="minimal" type="button" id="compose_btn" onclick="document.location.href='<?PHP echo site_url('inbox/compose') ?>';">Compose</button>
			<br/>
			<br/>
			<?PHP echo $mailboxes;?>	
		</div>
		<a class="hidden_context hidden_link" href="#menuContent" id="skipToMenu">Skip to Menu</a>
	</div>
	<a name="mainContent" id="mainContent" class="hidden_context hidden_link">Main Content</a>
	<h2 class="hidden_context">Compose Message</h2>
	<div id="msg_pane">	
		<div id="compose_body">
			<?PHP echo form_open_multipart(current_url()); ?>
			<?php echo form_hidden('msg_id', $message->id); ?>
			<?php echo form_hidden('parent_message_id', $parent_message_id); ?>
			<input type="hidden" name="flag_value" value="<?php echo $flag_value ?>" id="flag_value">
			<?php if(!empty($attachments)) echo form_hidden('reattach_id', $message->id); ?>
			<table id="compose_form">
				<tr><td>From</td><td><?php echo $CI->mailbox->email_address ?></td><td></td></tr>
				<tr>
					<td>To</td>
					<td>
						<?php echo form_label('To','message_to',array('class' => 'hidden_context')) ?>
						<?php echo form_label('To','token-input-message_to',array('class' => 'hidden_context')) ?> 
						<?php echo form_textarea(array('class' => 'expand','style' => 'resize: none; width: 100%; height: 19px; line-height: 15px;','name' => 'message_to', 'id' => 'message_to', 'value' => $to, 'autocomplete' => 'off')) ?> 
					</td>
					<td>
					<?php if(empty($cc)): ?>
						<a id="CC_link" href="javascript:addCC();">Add CC</a>
					<?php endif ?>
					</td>
				</tr>
				<tr <?php if(empty($cc)): ?>style="display: none;"<?php endif ?> >
					<td>CC</td>
					<td>
						<?php echo form_label('CC','token-input-message_cc',array('class' => 'hidden_context')) ?>
						<?php echo form_label('CC','message_cc',array('class' => 'hidden_context')) ?>
						<?php echo form_textarea(array('class' => 'expand','style' => 'resize: none; width: 100%; height: 19px; line-height: 15px;', 'name' => 'message_cc','id' => 'message_cc', 'value' => $cc, 'autocomplete' => 'off')) ?>
					</td>
					<td></td>
				</tr>
				<tr>
					<td>Subject</td>
					<td>
						<?php echo form_label('Subject','message_subject',array('class' => 'hidden_context')) ?>
						<?php echo form_input(array("style" => "width: 98%; min-width: 550px; margin-right: 0; margin-left: 0; padding-left: 0; padding-right: 0;", "name" => "message_subject", "id" => "message_subject", "value" => $subject)) ?>
					</td>
					<td>
						<?php echo form_label('Priority','priority',array('class' => 'hidden_context')) ?>
						<?php echo form_dropdown('priority',array("high" => "High Importance", "normal" => "Normal Importance", "low" => "Low Importance"), $message->importance, 'id="priority"') ?>
					</td>
				</tr>					
				<?php foreach($attachments as $key => $filename): ?>	
				<tr id="reattach_<?php echo $key ?>">
					<td><img src="/images/paperclip.png" alt="Attachments" /></td>
					<td>
						<a class="preview" target="_blank" href="/inbox/preview_attachment/<?php echo rawurlencode($filename) ?>" title="<?php echo $filename ?>">
							<?php echo $filename ?>
						</a>
						<span style="margin-right: 5px; display: block; float: left;"><?php echo byte_format(filesize($CI->user->attachment_cache().$filename)) ?></span>
						<a class="delete" href="#" onclick="$.ajax({ url: '/inbox/clear_attachment/<?php echo rawurlencode($filename) ?>/?'+$('input[type=hidden].token').attr('id')+'='+$('input[type=hidden].token').val()}); $('#attachment_size').val(parseInt($('#attachment_size').val()) - <?php echo filesize($CI->user->attachment_cache().$filename) ?>); $(this).parent().parent().remove(); deleteAttach();">Remove</a>
					</td>
				</tr>
				<?php endforeach ?>
				<tr>
					<td colspan="3">
						<div id="dropzone" style="display: none; border-radius: 5px; border: dashed black 1px; width: 700px; height: 50px;" >
							<h2 style="text-align: center;">Drag files here to attach</h2>
						</div>
					</td>
				</tr>
				<tr id="attach_row"><td><img src="/images/paperclip.png" alt="Attachment Icon" /></td><td><a href="javascript:addAttach();" class="attach_link">Attach a file...</a></td><td></td></tr>
				<tr>
					<td colspan="3">
						<?php echo form_label('Message Body','message_body',array('class' => 'hidden_context')) ?>
						<?php echo form_textarea(array('id' => 'message_body', 'name' => 'message_body','id' => 'message_body', 'style' => 'height: 100%; width: 100%', 'value' => $quote_body)) ?>
					</td>
				</tr>
			
			</table>

		</div>
	</div>
	<?php echo form_close(); ?>	
	<?PHP echo form_open_multipart('/inbox/attach/',array('id'=>'attachment_form')); ?>
		<label for="attach" class="hidden_context">Attach file</label>
		<input type="file" name="attach" id="attach"  />
		<input type="text" name="filler_input" id="filler_input" style="display: none;" />
		<?PHP echo form_hidden('attach_count', '0', 'attach_count'); ?>
		<?PHP echo form_hidden('attachment_size', $CI->user->attachment_cache_size_in_bytes(), 'attachment_size'); ?>
	<?PHP echo form_close(); ?>
</div>
<div id="feedback_failed" class="modal_msg" style="display:<?php echo $this->session->flashdata('error_message') ? '' : 'none'; ?>;">
	<?php echo $this->session->flashdata('error_message'); ?>
</div>
<?PHP $this->load->view("footer"); ?>
<div id="pros_modal"  style="height: 100px; width: 300px; display: none;"><p style="text-align: center; ">Processing Request...</p><img src="/images/ajax-loader-large.gif" alt="Processing..." style="display: block; margin-top: 10px; margin-right: auto; margin-left: auto;" /></div>
</body>
<script type="text/javascript">
	$(document).ready(function(){
		var lastLeft = -1,
		menu = $('#mailbox_wrapper, #header');

		$('#mailbox_wrapper').css('position', 'absolute');
		$(window).on('scroll resize', function(){
			var totalWidth = $('#wrapper').css('width').slice(0,-2);
			if (totalWidth > window.innerWidth) {
				$('#header').css('margin-left', '3%');
				var left = $(window).scrollLeft();
				if (left >= 0 && left!==lastLeft){
					lastLeft = left;
					menu.css('left',-left+'px');
				}
			}
		});
	});
</script>
</html>
